const tabla = document.querySelector("#tabla")
const infoDisplay = document.querySelector("#info")

const startCells = [
"", "", "", "", "", "", "", "", ""
]

let kovetkezik = "kor"
infoDisplay.textContent= "Kör kezd"

let jelekSzama=0

function setTabla(){
	startCells.forEach((_cell, index) => {
		const cellElement = document.createElement('div')
		cellElement.classList.add('negyzet')
		cellElement.id = index
		cellElement.addEventListener('click', lepes)
		tabla.append(cellElement)
	})
}
setTabla()

function lepes(e){
	jelekSzama++
	const kovetkezikDisplay = document.createElement('div')
	kovetkezikDisplay.classList.add(kovetkezik)
	e.target.append(kovetkezikDisplay)
	kovetkezik = kovetkezik === "kor" ? "kereszt" : "kor"
	infoDisplay.textContent = kovetkezik === "kor" ? "Kör következik" : "Kereszt következik"
	e.target.removeEventListener("click", lepes)
	eredmenyEllenorzese()
}

function eredmenyEllenorzese(){
	const allnegyzets = document.querySelectorAll(".negyzet")
	const wincomb = [
	[0,1,2], [3,4,5], [6,7,8],
	[0,3,6], [1,4,7], [2,5,8],
	[0,4,8], [2,4,6]
	]
	
	wincomb.forEach(array => {
		const korWins = array.every(cell =>
		allnegyzets[cell].firstChild?.classList.contains('kor'))

	    if(korWins){
			infoDisplay.textContent = "Kör nyert!"
	 		allnegyzets.forEach(negyzet => 	negyzet.removeEventListener("click", lepes))
			addRestart()
			return
		}
	})
	
	wincomb.forEach(array => {
		const keresztWins = array.every(cell =>
		allnegyzets[cell].firstChild?.classList.contains('kereszt'))

	    if(keresztWins){
			infoDisplay.textContent = "Kereszt nyert!"
			allnegyzets.forEach(negyzet => 	negyzet.removeEventListener("click", lepes))
			addRestart()
			return
		}
	}) 
	
	if( ( ! infoDisplay.textContent.includes("nyert") ) && (jelekSzama == 9) ){
		infoDisplay.textContent = "Döntetlen"
		addRestart()
	}
}

function addRestart(){
	const reButton = document.createElement('Button')
	reButton.textContent="Új játék"
	reButton.onclick = f5
	infoDisplay.append(reButton)
	
}
function f5(){
	location.reload()
}